################################################################################
#
# * Copyright (c) 2015-2017 Intel Corporation.  All rights reserved.
# *
# * This software is available to you under a choice of one of two
# * licenses.  You may choose to be licensed under the terms of the GNU
# * General Public License (GPL) Version 2, available from the file
# * COPYING in the main directory of this source tree, or the
# * OpenFabrics.org BSD license below:
# *
# *   Redistribution and use in source and binary forms, with or
# *   without modification, are permitted provided that the following
# *   conditions are met:
# *
# *    - Redistributions of source code must retain the above
# *	copyright notice, this list of conditions and the following
# *	disclaimer.
# *
# *    - Redistributions in binary form must reproduce the above
# *	copyright notice, this list of conditions and the following
# *	disclaimer in the documentation and/or other materials
# *	provided with the distribution.
# *
# * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
# * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
# * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
# * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# * SOFTWARE.
#
################################################################################

#!/bin/bash
print_usage() {
	echo
	echo "usage: $0 [absolute path to i40evf source directory] {k/3/4}"
	echo "          k - Default, Compile against current running kernel"
	echo "          3 - Compile against OFED 3.18-x source."
	echo "          4 - Compile against OFED 4.8-y source."
	echo
	exit
}

if [ "$#" -lt 1 ]; then
	print_usage
fi

if [ ! -e $1 ]; then
	echo "Invalid i40evf source path"
	print_usage
fi

if [ ! -e $1/i40evf.spec ]; then
	echo "Invalid i40evf source path"
	print_usage
fi

KERNEL_BUILD=`uname -r`
if [ -e /usr/src/kernels/linux-$KERNEL_BUILD/include/config ]; then
        KSRC="/usr/src/kernels/linux-$KERNEL_BUILD/"
elif [ -e /usr/src/kernels/$KERNEL_BUILD/include/config ]; then
        KSRC="/usr/src/kernels/$KERNEL_BUILD/"
elif [ -e /lib/modules/$KERNEL_BUILD/build/include/config ]; then
	KSRC="/lib/modules/$KERNEL_BUILD/build/"
fi

KERNEL_BUILD=`uname -r | sed 's/\([0-9]*\.[0-9]*\)\..*/\1/'`
if [ -e /usr/src/kernels/linux-$KERNEL_BUILD/include/config ]; then
        KSRC="/usr/src/kernels/linux-$KERNEL_BUILD/"
elif [ -e /usr/src/kernels/$KERNEL_BUILD/include/config ]; then
        KSRC="/usr/src/kernels/$KERNEL_BUILD/"
elif [ -e /lib/modules/$KERNEL_BUILD/build/include/config ]; then
	KSRC="/lib/modules/$KERNEL_BUILD/build/"
fi

export KSRC

if [ -e ${KSRC}/include/linux/kconfig.h ]; then
        INCLUDE_KCONF_HDR="-include ${KSRC}/include/linux/kconfig.h"
        export INCLUDE_KCONF_HDR
fi

if [ -e ${KSRC}/include/generated/autoconf.h ]; then
        INCLUDE_AUTOCONF_HDR="-include ${KSRC}/include/generated/autoconf.h"
        export INCLUDE_AUTOCONF_HDR
elif [ -e ${KSRC}/include/linux/autoconf.h ]; then
        INCLUDE_AUTOCONF_HDR="-include ${KSRC}/include/linux/autoconf.h"
        export INCLUDE_AUTOCONF_HDR
fi

if [ "$2" == "4" ]; then
	make -C $KSRC I40EVF_SRC=$1 M=$PWD/src/i40iwvf clean
        KBUILD_EXTRA_SYMBOLS="$1/src/Module.symvers /usr/src/compat-rdma/Module.symvers"
        export KBUILD_EXTRA_SYMBOLS
        INCLUDE_COMPAT_HDR="-include /usr/src/openib/include/linux/compat-2.6.h -I/usr/src/openib/include"
        export INCLUDE_COMPAT_HDR
        make "CFLAGS_MODULE=-DMODULE -D__OFED_BUILD__" -C $KSRC I40EVF_SRC=$1 M=$PWD/src/i40iwvf
elif [ "$2" == "3" ]; then
	make -C $KSRC I40EVF_SRC=$1 M=$PWD/src/i40iwvf clean
        KBUILD_EXTRA_SYMBOLS="$1/src/Module.symvers /usr/src/compat-rdma/Module.symvers"
        export KBUILD_EXTRA_SYMBOLS
        INCLUDE_COMPAT_HDR="-include /usr/src/openib/include/linux/compat-2.6.h -I/usr/src/openib/include"
        export INCLUDE_COMPAT_HDR
        make "CFLAGS_MODULE=-DMODULE -DOFED_3_18 -D__OFED_BUILD__" -C $KSRC I40EVF_SRC=$1 M=$PWD/src/i40iwvf
elif [ "$2" == "k" ] || [ "$2" == "" ]; then
	make -C $KSRC I40EVF_SRC=$1 M=$PWD/src/i40iwvf clean
        KBUILD_EXTRA_SYMBOLS="$1/src/Module.symvers"
        export KBUILD_EXTRA_SYMBOLS
        make "CFLAGS_MODULE=-DMODULE" -C $KSRC I40EVF_SRC=$1 M=$PWD/src/i40iwvf
else
	echo "Invalid argument: $2"
	print_usage
fi

make -C $KSRC M=$PWD/src/i40iwvf INSTALL_MOD_DIR=updates/drivers/infiniband/hw/i40iwvf modules_install
depmod -a
